(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20480,        514]
NotebookOptionsPosition[     19317,        468]
NotebookOutlinePosition[     19679,        484]
CellTagsIndexPosition[     19636,        481]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", "3"}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"3", ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.888980473692684*^9, 3.888980502036858*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1.0", ",", "6.0", ",", "0.25"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8889805327796793`*^9, 3.888980560494123*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.5237190142858297`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.25`", ",", "3.6402097948700334`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "4.82786105548445`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.75`", ",", "6.060867123048228`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "7.3248676035896345`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.25`", ",", "8.611902436349057`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", "9.917518847322611`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.75`", ",", "11.239183557287834`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "12.575419645736309`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.25`", ",", "13.925335216564813`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.5`", ",", "15.288363569255106`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.75`", ",", "16.66411855645468`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "18.05231346213796`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.25`", ",", "19.452715361553256`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.5`", ",", "20.865119525531835`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.75`", ",", "22.2893352440566`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "23.725178184354`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.25`", ",", "25.172466484901562`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.5`", ",", "26.631018967592368`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.75`", ",", "28.10065452766079`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.`", ",", "29.581192153964455`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8889805619209642`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fit1", "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"t", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"x", "^", "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.888980578612906*^9, 3.888980600032359*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.7324311537716309`"}], "+", 
  RowBox[{"1.700241385644111`", " ", "x"}], "+", 
  RowBox[{"2.148589250293057`", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"0.7213115495632378`", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"0.14083813384066385`", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"0.014398514922564042`", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"0.0006002204912394666`", " ", 
   SuperscriptBox["x", "6"]}]}]], "Output",
 CellChangeTimes->{3.888980602114834*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{"InterpolatingPolynomial", "[", 
    RowBox[{"t", ",", "x"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8889806293994884`*^9, 3.88898065169827*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.10154236596904553`"}], "+", 
  RowBox[{"0.9134342668094266`", " ", "x"}], "-", 
  RowBox[{"1.0394270240598014`", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"10.296020464236856`", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"16.891988716043386`", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"17.18665781976832`", " ", 
   SuperscriptBox["x", "5"]}], "-", 
  RowBox[{"12.779009766498397`", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"7.384435263300773`", " ", 
   SuperscriptBox["x", "7"]}], "-", 
  RowBox[{"3.417160695584923`", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"1.2866566485296456`", " ", 
   SuperscriptBox["x", "9"]}], "-", 
  RowBox[{"0.39740191791246054`", " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"0.10097161957794726`", " ", 
   SuperscriptBox["x", "11"]}], "-", 
  RowBox[{"0.02107471397909049`", " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"0.003593768534303651`", " ", 
   SuperscriptBox["x", "13"]}], "-", 
  RowBox[{"0.0004957213572653771`", " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"0.00005445043454056399`", " ", 
   SuperscriptBox["x", "15"]}], "-", 
  RowBox[{"4.6499492073529066`*^-6", " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"2.9748345220409673`*^-7", " ", 
   SuperscriptBox["x", "17"]}], "-", 
  RowBox[{"1.3410550361932227`*^-8", " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"3.7977563698957844`*^-10", " ", 
   SuperscriptBox["x", "19"]}], "-", 
  RowBox[{"5.080664960400864`*^-12", " ", 
   SuperscriptBox["x", "20"]}]}]], "Output",
 CellChangeTimes->{{3.8889806389343863`*^9, 3.888980653146474*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g1", "=", 
  RowBox[{"ListPlot", "[", "t", "]"}]}]], "Input",
 CellChangeTimes->{{3.8889806808305016`*^9, 3.8889807037084837`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.24720000000000014`, 0.24, 0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7G1NTWdMNmBxgPC/2LfEygSoyfNC+T/snQ/8
PrfLXxjK/2NvNLn6c7CdBJTP4CBz6rL4Kh9ZKJ/JofHNBjdvS0Uon8VhQ+5R
9qNXlaF8NodZUzNcyqrUoHwOh8WX49PnqmlC+VwOrt9ndh69qQ3l8zh8nXss
eclkPSifz2HP4oo1zKsMoHwBhxesjlkpvEZQvqDDfJcM9afFxlC+kIO/l2pl
xV0TKF/YYfHZR/cFvcygfBGHbZM43ZfuNIfyRR3e+FUcVtOxhPLFHFi+t5R2
LbSC8sUdwusP1B2RtIHyJRwkf/gynZxi6wAA/I9SJA==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 6.}, {0, 29.581192153964455`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0.12, 0.12}, {0.5916238430792892, 
   0.5916238430792892}}]], "Output",
 CellChangeTimes->{3.8889807045902014`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"fit1", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.888980711731462*^9, 3.888980732624384*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVjHk41Hkcx10pkfuY/BaRYpDCCuP4fn4p6VmGsGWUI5UjzTpqMZUctaGs
EkZWKUeIFFlsqF+OdRRPs6QxMZNjzKzyrJ2IIcfaP97P+3k97+f11g+O9Dot
JSEh4b2e/7vIt6oxzeyK09PxrbOqUUKidEkzpYR5ApkN0/S1vISE+40N5ARm
NIp1o3BFVkKieODScjgzGVWKM2mmCwKiN842JIiZhT7Y4vyaiwJi7JBmwTFm
EaLX0fW0EyaJactfrGnMWjQyOKMtFTxBRJe3SPkyW5G3ezl5NJpL7NdNtLk7
3oq0Wz+8GsG4BCkXPztq3oZMux0br/45QrxK6RwM62pDQ3fnb7O1RgjFAFYF
Q9yOjNJDmzL/+EA8VudTC/w60YNBIEV9YhOCZPkCnu4bVGrtG3pKpZ8wN6/O
f+bdj0SjLyzrh+sJU0IUdZkyjCoth1/HyA0iyVRWxA9LYygpOve0NHkKPcrx
stnQIECrfQ7DPh5fETPBo3hs22ck/LIvUqixioje2IcRn2ZQj23AxKKGDES8
IIv7qF/Q4+qgPe8PygEp5Uf6QuIc8uYqGjdSFWGCwXwSNzqPjC2yFDTmVcDz
Yw5KJy0i5533mqIeqoPVHH2OfuAbcjyvkLbJRwusHY7//KhoBeWV1OmPu2oD
R7TRJXZwDY0lH3xHV9cBKv2UyO07SUjJP9zvrroNztg9O+zqKgXKYFM2xdSH
oy08mkKQNCinpI5YyGyHd0Ma3Rdvyqyvd8+Rsw3B4LEpr65yAyga3Ps2I7cT
1khufnlcWdi0tzuRUWwEeVxaGH/zJji4hy0QWZNBguaiu7RdDj6HGmERNSYg
pjtSmn02g/+jvigpdzNotVNb3R8tD/6xyTRf1i444P/e2zZNAcJaM2RUqLuB
pl2qxG7YAjGMxRLruD3glOl5zukvRfAJtw5Ko1gAp+9KYYWkMowIX+sGKllC
tMSRXkGeMvz+0isvfswSYjK1qHKGKnB1y+RAVJkVUMJ5KZItKpARpkfRSfge
Iu7nyPMOqULNYsCRiy7WwEjG/WfeqcJzZs6ldoW94FEze+J9hBoYHYqO5/H3
wq+U3KYisRoYtmhbHX9qA9kqDp37stShzWSB2XPDFqT29+/o1tMA5R1+OvF+
dkA1CKSmVGkAKz3n3NQOCgS7i8iqzprg0lOTdl3aHngDMbRrLE34TFO77D9g
Dwbli/ascC0YD2p26q53AOedcUKqBAkCjCLxpFxH6JPgC2ozSNCh6HbpeagT
6Bkfyf9kuBX4pZ329e4IOJWN9zfWbYWbg/+aBasBRHOUImlO2rDEjuTrJwKw
fOiipEFtaMw9embyK8Ad06aujGAMpI/lMYZDcBiaOp8jdRqDj86rFE4YDqSK
3SfiQzEgBz0wZ5/BId/w4dLJsxhU9+DVAz/h8JvOrV32sRjY76tVeBuLQ4FS
SPZUOgbnOaEX3l7DoXBWJdClFoOk2T5XcRkOvNpe05Y6DO5wZcuXK3DQjUoV
WzRgQLmt5ihZhcP96eUsnWYMpvtOqsg/xeHBpLBjrgMDT45skH4jDkXsFyYl
QxiE+K289O3CYTw3foE0vP7n+aQmqAcHAx+rjkwuBm3tu7lhb3AoZlX4XxjH
wIsdKmS8Xeee7FuHpzEIllXsLGSv+6lU/65/MPjiXpJdwVn3XeRMHEUYXJjK
vvdsGIeStsvtxvMYlMl5hHZ9xIGfZHerUIzBMifBqH8MB0M0d1z9GwYNuSxD
7gQOp1aekK+vYCBoZAT+PYlDaXP4/NraOnOr2LNCHP4Dimxnaw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 7}, {-0.7324309108799606, 35.81212898151334}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.888980733717687*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g1", ",", "g2"}], "]"}]], "Input",
 CellChangeTimes->{{3.8889807420803213`*^9, 3.8889807461680408`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7G1NTWdMNmBxgPC/2LfEygSoyfNC+T/snQ/8
PrfLXxjK/2NvNLn6c7CdBJTP4CBz6rL4Kh9ZKJ/JofHNBjdvS0Uon8VhQ+5R
9qNXlaF8NodZUzNcyqrUoHwOh8WX49PnqmlC+VwOrt9ndh69qQ3l8zh8nXss
eclkPSifz2HP4oo1zKsMoHwBhxesjlkpvEZQvqDDfJcM9afFxlC+kIO/l2pl
xV0TKF/YYfHZR/cFvcygfBGHbZM43ZfuNIfyRR3e+FUcVtOxhPLFHFi+t5R2
LbSC8sUdwusP1B2RtIHyJRwkf/gynZxi6wAA/I9SJA==
      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVjHk41Hkcx10pkfuY/BaRYpDCCuP4fn4p6VmGsGWUI5UjzTpqMZUctaGs
EkZWKUeIFFlsqF+OdRRPs6QxMZNjzKzyrJ2IIcfaP97P+3k97+f11g+O9Dot
JSEh4b2e/7vIt6oxzeyK09PxrbOqUUKidEkzpYR5ApkN0/S1vISE+40N5ARm
NIp1o3BFVkKieODScjgzGVWKM2mmCwKiN842JIiZhT7Y4vyaiwJi7JBmwTFm
EaLX0fW0EyaJactfrGnMWjQyOKMtFTxBRJe3SPkyW5G3ezl5NJpL7NdNtLk7
3oq0Wz+8GsG4BCkXPztq3oZMux0br/45QrxK6RwM62pDQ3fnb7O1RgjFAFYF
Q9yOjNJDmzL/+EA8VudTC/w60YNBIEV9YhOCZPkCnu4bVGrtG3pKpZ8wN6/O
f+bdj0SjLyzrh+sJU0IUdZkyjCoth1/HyA0iyVRWxA9LYygpOve0NHkKPcrx
stnQIECrfQ7DPh5fETPBo3hs22ck/LIvUqixioje2IcRn2ZQj23AxKKGDES8
IIv7qF/Q4+qgPe8PygEp5Uf6QuIc8uYqGjdSFWGCwXwSNzqPjC2yFDTmVcDz
Yw5KJy0i5533mqIeqoPVHH2OfuAbcjyvkLbJRwusHY7//KhoBeWV1OmPu2oD
R7TRJXZwDY0lH3xHV9cBKv2UyO07SUjJP9zvrroNztg9O+zqKgXKYFM2xdSH
oy08mkKQNCinpI5YyGyHd0Ma3Rdvyqyvd8+Rsw3B4LEpr65yAyga3Ps2I7cT
1khufnlcWdi0tzuRUWwEeVxaGH/zJji4hy0QWZNBguaiu7RdDj6HGmERNSYg
pjtSmn02g/+jvigpdzNotVNb3R8tD/6xyTRf1i444P/e2zZNAcJaM2RUqLuB
pl2qxG7YAjGMxRLruD3glOl5zukvRfAJtw5Ko1gAp+9KYYWkMowIX+sGKllC
tMSRXkGeMvz+0isvfswSYjK1qHKGKnB1y+RAVJkVUMJ5KZItKpARpkfRSfge
Iu7nyPMOqULNYsCRiy7WwEjG/WfeqcJzZs6ldoW94FEze+J9hBoYHYqO5/H3
wq+U3KYisRoYtmhbHX9qA9kqDp37stShzWSB2XPDFqT29+/o1tMA5R1+OvF+
dkA1CKSmVGkAKz3n3NQOCgS7i8iqzprg0lOTdl3aHngDMbRrLE34TFO77D9g
Dwbli/ascC0YD2p26q53AOedcUKqBAkCjCLxpFxH6JPgC2ozSNCh6HbpeagT
6Bkfyf9kuBX4pZ329e4IOJWN9zfWbYWbg/+aBasBRHOUImlO2rDEjuTrJwKw
fOiipEFtaMw9embyK8Ad06aujGAMpI/lMYZDcBiaOp8jdRqDj86rFE4YDqSK
3SfiQzEgBz0wZ5/BId/w4dLJsxhU9+DVAz/h8JvOrV32sRjY76tVeBuLQ4FS
SPZUOgbnOaEX3l7DoXBWJdClFoOk2T5XcRkOvNpe05Y6DO5wZcuXK3DQjUoV
WzRgQLmt5ihZhcP96eUsnWYMpvtOqsg/xeHBpLBjrgMDT45skH4jDkXsFyYl
QxiE+K289O3CYTw3foE0vP7n+aQmqAcHAx+rjkwuBm3tu7lhb3AoZlX4XxjH
wIsdKmS8Xeee7FuHpzEIllXsLGSv+6lU/65/MPjiXpJdwVn3XeRMHEUYXJjK
vvdsGIeStsvtxvMYlMl5hHZ9xIGfZHerUIzBMifBqH8MB0M0d1z9GwYNuSxD
7gQOp1aekK+vYCBoZAT+PYlDaXP4/NraOnOr2LNCHP4Dimxnaw==
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 6.}, {0, 29.581192153964455`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0.12, 0.12}, {0.5916238430792892, 
   0.5916238430792892}}]], "Output",
 CellChangeTimes->{3.8889807470061073`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g3", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"p", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8889807594512925`*^9, 3.888980771057082*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3k41GsbB/CxRFQk26STPVKqE8kW9/1LeTll0CKUl5yiCSfUSassiYOk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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 7}, {-0.10154223547845721`, 35.59492186398711}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.8889807720681515`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g1", ",", "g3"}], "]"}]], "Input",
 CellChangeTimes->{{3.8889807785144267`*^9, 3.888980783712617*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7G1NTWdMNmBxgPC/2LfEygSoyfNC+T/snQ/8
PrfLXxjK/2NvNLn6c7CdBJTP4CBz6rL4Kh9ZKJ/JofHNBjdvS0Uon8VhQ+5R
9qNXlaF8NodZUzNcyqrUoHwOh8WX49PnqmlC+VwOrt9ndh69qQ3l8zh8nXss
eclkPSifz2HP4oo1zKsMoHwBhxesjlkpvEZQvqDDfJcM9afFxlC+kIO/l2pl
xV0TKF/YYfHZR/cFvcygfBGHbZM43ZfuNIfyRR3e+FUcVtOxhPLFHFi+t5R2
LbSC8sUdwusP1B2RtIHyJRwkf/gynZxi6wAA/I9SJA==
      "]]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3k41GsbB/CxRFQk26STPVKqE8kW9/1LeTll0CKUl5yiCSfUSassiYOk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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 6.}, {0, 29.581192153964455`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0.12, 0.12}, {0.5916238430792892, 
   0.5916238430792892}}]], "Output",
 CellChangeTimes->{3.8889807868563223`*^9}]
}, Open  ]]
},
WindowSize->{707, 456},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->2.,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 333, 10, 60, "Input"],
Cell[CellGroupData[{
Cell[915, 34, 338, 10, 99, "Input"],
Cell[1256, 46, 1768, 45, 430, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3061, 96, 338, 10, 99, "Input"],
Cell[3402, 108, 553, 14, 134, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3992, 127, 225, 5, 99, "Input"],
Cell[4220, 134, 1681, 42, 504, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5938, 181, 155, 3, 60, "Input"],
Cell[6096, 186, 826, 19, 339, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6959, 210, 235, 6, 60, "Input"],
Cell[7197, 218, 2266, 44, 324, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9500, 267, 152, 3, 60, "Input"],
Cell[9655, 272, 2728, 51, 339, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12420, 328, 234, 6, 60, "Input"],
Cell[12657, 336, 2998, 56, 330, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15692, 397, 150, 3, 60, "Input"],
Cell[15845, 402, 3456, 63, 396, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

